-- name: \\#7A9FFF\\Blue Archive NPCs + Items
-- description: Replaces Bowser, Koopa the Quick, Koopa Shell, Toad, Goomba, Lakitu with Camera & Enemy, Thwomp, Peach, Penguins, Coins, 1Ups, Star

-- Replaces the model of Koopa the Quick with Sumire

E_MODEL_SUMIRE2 = smlua_model_util_get_id("sumire2_geo")
E_MODEL_JTF = smlua_model_util_get_id("JTF_geo")

local function sumire_init(o)
    o.oFlags = (OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_SET_FACE_ANGLE_TO_MOVE_ANGLE)
    obj_set_model_extended(o, E_MODEL_SUMIRE2)
    o.oUnkBC = 0
end

local function sumire_loop(o)
    local koopa_obj = find_object_with_behavior(get_behavior_from_id(id_bhvKoopa))
    if koopa_obj ~= nil and koopa_obj.oKoopaMovementType >= KOOPA_BP_KOOPA_THE_QUICK_BASE then
        o.oPosX = koopa_obj.oPosX
        o.oPosY = koopa_obj.oPosY
        o.oPosZ = koopa_obj.oPosZ
        o.oMoveAngleYaw = koopa_obj.oMoveAngleYaw
        if koopa_obj.oAction == KOOPA_THE_QUICK_ACT_RACE then
            if koopa_obj.oSubAction == KOOPA_THE_QUICK_SUB_ACT_JUMP then
                o.oUnkBC = 0
                smlua_anim_util_set_animation(o, "sumire_jump")
                o.header.gfx.animInfo.animAccel = 0x10000
            else
                smlua_anim_util_set_animation(o, "sumire_running")
                o.header.gfx.animInfo.animAccel = 0x10000 * (koopa_obj.oForwardVel / 5) + 0x10000
                if o.oUnkBC == 0 then
                    o.header.gfx.animInfo.animFrame = 0
                    o.oUnkBC = 1
                end
            end
        else
            o.oUnkBC = 0
            smlua_anim_util_set_animation(o, "sumire_idle")
            o.header.gfx.animInfo.animAccel = 0x10000
        end
    else
        obj_mark_for_deletion(o)
    end
end

local function jtf_init(o)
    o.oFlags = (OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_SET_FACE_ANGLE_TO_MOVE_ANGLE)
    obj_set_model_extended(o, E_MODEL_JTF)
end

local function jtf_loop(o)
    local toad_obj = o.parentObj
    if toad_obj ~= nil and get_id_from_behavior(toad_obj.behavior) == id_bhvToadMessage and toad_obj.oSyncID ~= 0 then
        o.oPosX = toad_obj.oPosX
        o.oPosY = toad_obj.oPosY
        o.oPosZ = toad_obj.oPosZ
        o.oMoveAngleYaw = toad_obj.oMoveAngleYaw
        smlua_anim_util_set_animation(o, "sumire_idle")
    else
        obj_mark_for_deletion(o)
    end
end

id_bhvSumire = hook_behavior(nil, OBJ_LIST_UNIMPORTANT, false, sumire_init, sumire_loop)
id_bhvJtf = hook_behavior(nil, OBJ_LIST_UNIMPORTANT, false, jtf_init, jtf_loop)


local toadSpawnTable = {}

local function toad_ugly_recursive_function(toad_obj)
    if not toadSpawnTable[toad_obj.oSyncID] then
        obj_scale(toad_obj, 0)
        spawn_non_sync_object(id_bhvJtf, E_MODEL_NONE, 0 , 0 , 0 , function(o)
            o.parentObj = toad_obj
        end)
        toadSpawnTable[toad_obj.oSyncID] = true
    end
    local nextToad = obj_get_next_with_same_behavior_id(toad_obj)
    if nextToad ~= nil then
        toad_ugly_recursive_function(nextToad)
    end
end

local function replace_update()
    -- Koopa the Quick
    local koopa_obj = find_object_with_behavior(get_behavior_from_id(id_bhvKoopa))
    if koopa_obj ~= nil and koopa_obj.oKoopaMovementType >= KOOPA_BP_KOOPA_THE_QUICK_BASE then
        obj_scale(koopa_obj, 0)
        if ktq_spawned_dummy_model == false then
            ktq_spawned_dummy_model = true
            spawn_non_sync_object(id_bhvSumire, E_MODEL_NONE, 0 , 0 , 0 , nil)
        end
    else
        ktq_spawned_dummy_model = false
    end

    local toad_obj = find_object_with_behavior(get_behavior_from_id(id_bhvToadMessage))
    if toad_obj ~= nil then
        toad_ugly_recursive_function(toad_obj)
    end
end

function reset_spawn_tables()
    toadSpawnTable = {}
    ktq_spawned_dummy_model = false
end

hook_event(HOOK_UPDATE, replace_update)
hook_event(HOOK_ON_LEVEL_INIT, reset_spawn_tables)
hook_event(HOOK_ON_WARP, reset_spawn_tables)